package com.alexscottrhodes.chartModel;

import java.util.ArrayList;

import com.alexscottrhodes.chartModel.components.PieSlice;
/**
 * Model of the Google Pie Chart object
 * @author Alex Rhodes
 *
 */
public class GooglePieChart {
	String id;
	private String title;
	private String dataType;
	private String dataName;
	private String titleColor;
	private boolean titleBold;
	private ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
	private int width;
	private int height;
	private boolean is3d;
	private boolean showSliceText = true;
	private double donutHoleSize;
	private int rotation;
	
	public GooglePieChart(String dataName, String dataType){
		this.dataName = dataName;
		this.dataType  = dataType;
	}
	
	public void addSlice(PieSlice slice){
		slices.add(slice);
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getTitleColor() {
		return titleColor;
	}
	public void setTitleColor(String titleColor) {
		this.titleColor = titleColor;
	}
	public boolean isTitleBold() {
		return titleBold;
	}
	public void setTitleBold(boolean titleBold) {
		this.titleBold = titleBold;
	}
	public ArrayList<PieSlice> getSlices() {
		return slices;
	}
	public void setSlices(ArrayList<PieSlice> slices) {
		this.slices = slices;
	}
	public int getWidth() {
		return width;
	}
	public void setWidth(int width) {
		this.width = width;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	public boolean isIs3d() {
		return is3d;
	}
	public void setIs3d(boolean is3d) {
		this.is3d = is3d;
	}
	public void setDonutHoleSize(double d) {
		this.donutHoleSize = d;
	}
	public int getRotation() {
		return rotation;
	}
	public void setRotation(int rotation) {
		this.rotation = rotation;
	}
	public String getDataType() {
		return dataType;
	}
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	public String getDataName() {
		return dataName;
	}
	public void setDataName(String dataName) {
		this.dataName = dataName;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public double getDonutHoleSize() {
		return donutHoleSize;
	}

	public boolean isShowSliceText() {
		return showSliceText;
	}

	public void setShowSliceText(boolean showSliceText) {
		this.showSliceText = showSliceText;
	}
	
	
	
}
