package com.alexscottrhodes.demo.push;

import javax.inject.Singleton;

import org.primefaces.push.EventBus;
import org.primefaces.push.RemoteEndpoint;
import org.primefaces.push.annotation.OnClose;
import org.primefaces.push.annotation.OnMessage;
import org.primefaces.push.annotation.OnOpen;
import org.primefaces.push.annotation.PushEndpoint;
import org.primefaces.push.impl.JSONDecoder;
import org.primefaces.push.impl.JSONEncoder;
 
@PushEndpoint("/push")
@Singleton
public class PushEndpoints {
         
    @OnMessage(encoders = {JSONEncoder.class},decoders={JSONDecoder.class})
    public String onMessage(String message) {
        return message;
    }
    
    @OnOpen
    public void onOpen(RemoteEndpoint r, EventBus eventBus) {
    }
 
    @OnClose
    public void onClose(RemoteEndpoint r, EventBus eventBus) {
    }
}
